// // // CHANGE THIS // // //
var themeName = 'mxb';

// REQUIRE PLUGINS
var gulp = require('gulp');
var sass = require('gulp-sass');
var watch = require('gulp-watch');
var autoprefixer = require('gulp-autoprefixer');
var sourcemaps = require('gulp-sourcemaps');
var browserSync = require('browser-sync');
var emailBuilder = require('gulp-email-builder');


//LOCAL DEVELOPMENT
gulp.task('theme-sass', function(done) {
  gulp.src('css/style.scss')
  .pipe(sourcemaps.init())
  .pipe(sass().on('error', sass.logError)) 
  .pipe(autoprefixer())
  .pipe(sourcemaps.write())
  .pipe(gulp.dest('css'));
  done();
});

gulp.task('theme-sass-resp', function(done) {
  gulp.src('css/responsive.scss')
  .pipe(sourcemaps.init())
  .pipe(sass().on('error', sass.logError)) 
  .pipe(autoprefixer())
  .pipe(sourcemaps.write())
  .pipe(gulp.dest('css'));
  done();
});

const options = {
  encodeSpecialChars: true
}
const builder = emailBuilder();

gulp.task('emailBuilder', function(done) {
  gulp.src(['*.html'])
    .pipe(builder.build())
    .pipe(gulp.dest('dist/'));
    done();
});

gulp.task('watch',function(done) {
    browserSync.init({
      proxy: "http://localhost/projects/" + themeName + "/mxb-emails/"
    });
    gulp.watch('css/blocks/*.scss',gulp.series('theme-sass'));
    gulp.watch('css/blocks/*.scss',gulp.series('theme-sass-resp'));
    gulp.watch('css/style.css',gulp.series('emailBuilder'));
    gulp.watch('*.html',gulp.series('emailBuilder'));
    gulp.watch('**/*').on('change', browserSync.reload);
    done();
}); 